console.log("Running!");
console.log("System Date: " + new Date().toUTCString());

var ENABLE_PIN = 9;
var CLOCK_PIN1 = 10;
var CLOCK_PIN2 = 11;

var mraa = require('mraa'); //require mraa
console.log('MRAA Version: ' + mraa.getVersion()); //write the mraa version to the console

var enablePin = new mraa.Pwm(ENABLE_PIN);
enablePin.enable(true);
enablePin.period_us(500); //set the period in microseconds.
enablePin.write(0.8); //Write duty cycle value. 

var clockPin1 = new mraa.Gpio(CLOCK_PIN1);
var clockPin2 = new mraa.Gpio(CLOCK_PIN2);
clockPin1.dir(mraa.DIR_OUT);   //set the gpio direction to output
clockPin2.dir(mraa.DIR_OUT);   //set the gpio direction to output
//clockPin.write(ledState?1:0);

var fs = require('fs');

var express = require('express');
var app = express();
var http = require('http').Server(app);
var io = require('socket.io')(http);

var bodyParser = require('body-parser');

// Create application/x-www-form-urlencoded parser
var urlencodedParser = bodyParser.urlencoded({ extended: false })


io.on('connection', function(socket)
{
  console.log('a user connected');
  if(sysTimeAdjustment == 0)                                                                  // first connection after edison boot?
    socket.emit('Client System Time Request');                                                // sync edison clock to client's

  socket.on('connection request', function(userName)
  {
    // send to specific socket
    socket.emit('countdown', 5);
    console.log("Connected to socket!");
  });

  socket.on('disconnect', function()
  {                                                
  });

  socket.on('watch request',  function()
  {
    // send to all sockets
    //io.emit('watch update', {playerData: "ME", ballPos: 5, ballVisible: false, state: 0});
  });
});


app.use(express.static(__dirname + '/public'));

app.get('/', function (req, res)
{
   res.sendFile( __dirname + "/" + "Time_Warp.html" );
})

app.post('/save_:id', urlencodedParser, function (req, res)
{
  var success = true;
  console.log("ID: " + req.params.id);
  console.log(JSON.stringify(req.body));
  
  var heading = "";
  if(req.body.hasOwnProperty("timeWarp_speed_select"))
  {
    switch(req.body.timeWarp_speed_select)
    {
      case "1":
        heading += "Speed up ";
        break;
      case "2":
        heading += "Slow down ";
        break;
      case "3":
        heading += "Stop ";
        break;
      case "4":
        heading += "Sync ";
        break;
      default:
        success = false;
        break;
    }
  }
  else
    success = false;
    
  if(req.body.hasOwnProperty("timeWarp_start_select") && req.body.hasOwnProperty("timeWarp_start_input"))
  {
    switch(req.body.timeWarp_start_select)
    {
      case "1":
        heading += "at " + req.body.timeWarp_start_input + ", ";
        break;
      case "2":
        heading += "in " + req.body.timeWarp_start_input + " hours, ";
        break;
      default:
        success = false;
        break;
    }
  }
  else
    success = false;

  if(req.body.hasOwnProperty("timeWarp_end_select") && req.body.hasOwnProperty("timeWarp_end_input"))
  {
    switch(req.body.timeWarp_end_select)
    {
      case "1":
        heading += " till " + req.body.timeWarp_end_input;
        break;
      case "2":
        heading += " for " + req.body.timeWarp_end_input + " hours";
        break;
      default:
        success = false;
        break;
    }
  }
  else
    success = false;

  if(req.body.hasOwnProperty("timeWarp_change_select") && req.body.hasOwnProperty("timeWarp_change_input"))
  {
    switch(req.body.timeWarp_change_select)
    {
      case "1":
        heading += ", by " + req.body.timeWarp_change_input + " hours";
        break;
      case "2":
        heading += ", by " + req.body.timeWarp_change_input + "%";
        break;
      default:
        success = false;
        break;
    }
  }
//  else
//    success = false;

  if(req.body.hasOwnProperty("repeat_check"))
  {
    var firstOccurence = true;
    heading += " (";
    
    if(req.body.hasOwnProperty("repeat_check_Mon"))
    {
      if(firstOccurence)
        firstOccurence = false;
      heading += "Mon";
    }
    
    if(req.body.hasOwnProperty("repeat_check_Tue"))
    {
      if(firstOccurence)
        firstOccurence = false;
      else
        heading += ",";

      heading += "Tue";
    }
    
    if(req.body.hasOwnProperty("repeat_check_Wed"))
    {
      if(firstOccurence)
        firstOccurence = false;
      else
        heading += ",";
      heading += "Wed";
    }
    
    if(req.body.hasOwnProperty("repeat_check_Thu"))
    {
      if(firstOccurence)
        firstOccurence = false;
      else
        heading += ",";
      heading += "Thu";
    }
    
    if(req.body.hasOwnProperty("repeat_check_Fri"))
    {
      if(firstOccurence)
        firstOccurence = false;
      else
        heading += ",";
      heading += "Fri";
    }
    
    if(req.body.hasOwnProperty("repeat_check_Sat"))
    {
      if(firstOccurence)
        firstOccurence = false;
      else
        heading += ",";
      heading += "Sat";
    }
    
    if(req.body.hasOwnProperty("repeat_check_Sun"))
    {
      if(firstOccurence)
        firstOccurence = false;
      else
        heading += ",";
      heading += "Sun";
    }
    
    heading += ")";
  }

  
  if(success)
  {
    var filename = __dirname + "/public/settings.json";
    var file_content = fs.readFileSync(filename);
    var content = JSON.parse(file_content);
    
    req.body.title = heading;
    
    //change the value of the in-memory object
    if(req.params.id == "new")
    {
      content.Settings[content.Settings.length] = req.body; //JSON.stringify(req.body);
      //content.Settings[content.Settings.length].title = heading;
      //success = true;
    }
    else
    {
      var receivedID = parseInt(req.params.id) - 1;
      if(receivedID >= 0 && receivedID < content.Settings.length)
      {
        content.Settings[receivedID] = req.body; //JSON.stringify(req.body);
        //content.Settings[receivedID].title = heading;
        //success = true;
      }
      else
        success = false;
    }
    
    //console.log("Writing to file: " + JSON.stringify(content));

    //Serialize as JSON and Write it to a file
    if(success)
      fs.writeFileSync(filename, JSON.stringify(content));
  }
  
  if(success)
    res.end("Success!");
  else
    res.end("Fail");
})

app.post('/delete_:id', urlencodedParser, function (req, res)
{
  console.log("ID: " + req.params.id);
  //console.log(JSON.stringify(req.body));

  var filename = __dirname + "/public/settings.json";
  var file_content = fs.readFileSync(filename);
  var content = JSON.parse(file_content);
  
  var receivedID = parseInt(req.params.id) - 1;
  if(receivedID >= 0 && receivedID < content.Settings.length && content.Settings[receivedID].active == "no")
  {
    for(i = 0; i < scheduler.length; i++)
    {
      if(scheduler[i].id > receivedID)                                        // if the schedule is from a setting appearing after the one being deleted
        scheduler[i].id--;                                                    // reduce the schedule's ID to compensate for deleted entry
      else if(scheduler[i].id == receivedID)
        console.log("There is an entry of deleted entry in scheduler! Error!");
    }
    
    //checkScheduler();???
    
    //delete the JSON file object
    content.Settings.splice(receivedID, 1);
    //delete content.Settings[receivedID];

    //Serialize as JSON and Write it to a file
    fs.writeFileSync(filename, JSON.stringify(content));
    console.log("Deleted");
    res.end("Success!");
  }
  else
    res.end("Fail");
})

app.post('/active_:id', urlencodedParser, function (req, res)
{
  console.log("ID: " + req.params.id);
  console.log("JSON: " + JSON.stringify(req.body));

  var success = true;
  var failMessage = "";
  
  var filename = __dirname + "/public/settings.json";
  var file_content = fs.readFileSync(filename);
  var content = JSON.parse(file_content);
  
  var receivedID = parseInt(req.params.id) - 1;
  if(receivedID >= 0 && receivedID < content.Settings.length)
  {
    if(req.body.active == "no")                                       // the setting was set to OFF
    {
      content.Settings[receivedID].active = req.body.active;
      
      // checkScheduler is called at end which removes all schedules from this setting from scheduler
      
      // var searchResult = searchScheduler(schedulerEntry);
      // if(searchResult != -1)                                          // if the schedule exists in scheduler
      // {
        // scheduler.splice(searchResult, 1);                            // remove the scheduler entry
        
        // if(runningDuration != null)
        // {
          // if(runningDuration == searchResult)
          // {
            // timeoutObj.clearTimeout();                                // remove the timeout
            // runningDuration = null;
            
            ////stop using the setting!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          // }
          // else if(runningDuration > searchResult) // if running schedule has index which appears after the deleted entry
            // runningDuration--;                                          // reduce runningDuration by one to compensate for deleted entry
        // }
      // }
    }
    else
    {
      console.log("yo: " + req.body.active);
      
      var currTime = new Date();
      currTime.setTime(currTime.getTime() + sysTimeAdjustment);
      
      var activeTimes = [];
      
      var clash = false;
      
      // empty the existing startTimes array in JSON file
      // if(content.Settings[receivedID].hasOwnProperty("startTimes"))
      // {
        // console.log("Start time length: " + content.Settings[receivedID].startTimes.length);
        // content.Settings[receivedID].startTimes.splice(0, content.Settings[receivedID].startTimes.length);
      // }
      
      if(content.Settings[receivedID].hasOwnProperty("activeTimes"))
      {
        console.log("Active time length: " + content.Settings[receivedID].activeTimes.length);
        content.Settings[receivedID].activeTimes.splice(0, content.Settings[receivedID].activeTimes.length);
      }
      
      // Setting start time
      var startTime = new Date(currTime.getTime());

      var startValSegmented = content.Settings[receivedID].timeWarp_start_input.split(":");
      
      console.log("Start Times:");
      
      if(content.Settings[receivedID].timeWarp_start_select == "1")      // at selected
      {
        startTime.setHours(parseInt(startValSegmented[0]));
        startTime.setMinutes(parseInt(startValSegmented[1]));
        startTime.setSeconds(0);
        startTime.setMilliseconds(0);
                
        if(startTime < currTime)                          // If the startTime has already passed
          startTime.setDate(startTime.getDate() + 1);         // set startTime to tomorrow
        
        if(content.Settings[receivedID].hasOwnProperty("repeat_check"))  // 'Repeat?' checked?
        {
          var days = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
  
          for(i = 0; i < 7; i++)
          {
            if(content.Settings[receivedID].hasOwnProperty("repeat_check_" + days[startTime.getDay()]))
            {
              activeTimes.push({"startTime" : new Date(startTime.getTime()), "repeat" : "yo"});
              console.log(startTime.toUTCString());
            }
            startTime.setDate(startTime.getDate() + 1);                     // set startTime up for next day
          }
          
          // content.Settings[receivedID].hasOwnProperty("repeat_check_Mon")
          // {
            // startTime.setDate
            // activeTimes.push({"startTime" : startTime.toJSON(), "repeat" : "no"});
          // }
        }
        else                                                                // if no repeat
        {
          activeTimes.push({"startTime" : startTime, "repeat" : "no"});
          console.log(startTime.toUTCString());
          //content.Settings[receivedID].activeTimes = activeTimes;
        }
      }
      else if(content.Settings[receivedID].timeWarp_start_select == "2")    // in selected
      {
        startTime.setHours(startTime.getHours() + parseInt(startValSegmented[0]));
        startTime.setMinutes(startTime.getMinutes() + parseInt(startValSegmented[1]));
        
        activeTimes.push({"startTime" : new Date(startTime.getTime()), "repeat" : "no"});
        console.log(startTime.toUTCString());
        //console.log(activeTimes[activeTimes.length - 1]);
          
        // there is no repeat for 'in'
      }
      
      // Setting end times
      var endValSegmented = content.Settings[receivedID].timeWarp_end_input.split(":");
      var endHours = parseInt(endValSegmented[0]);
      var endMinutes = parseInt(endValSegmented[1]);
      
      console.log("End Times: ");
      
      for(i = 0; i < activeTimes.length; i++)
      {
        var endTime = new Date(activeTimes[i].startTime.getTime());
        //console.log("Start Time: " + endTime.toUTCString());
        
        if(content.Settings[receivedID].timeWarp_end_select == "1")           // till selected
        {        
          endTime.setHours(endHours);
          endTime.setMinutes(endMinutes);
          endTime.setSeconds(0);
          endTime.setMilliseconds(0);

          if(endTime <= activeTimes[i].startTime)                             // If the endTime is before startTime
            endTime.setDate(endTime.getDate() + 1);                           // set endTime up for next day
        }
        else if(content.Settings[receivedID].timeWarp_end_select == "2")      // for selected
        {
          endTime.setHours(endTime.getHours() + endHours);
          endTime.setMinutes(endTime.getMinutes() + endMinutes);
        }
        
        activeTimes[i].endTime = new Date(endTime.getTime());
        console.log(endTime.toUTCString());
      }

      var tickVal = null;
      if(content.Settings[receivedID].timeWarp_speed_select == "1")           // Speed up selected
      {
        if(content.Settings[receivedID].timeWarp_change_select == "1")        // hours selected
        {
          // what's the time difference between the start and end time in ms
          var timeDiff = activeTimes[0].endTime.getTime() - activeTimes[0].startTime.getTime();
          
          var changeValSegmented = content.Settings[receivedID].timeWarp_change_input.split(":");
          var changeHours = parseInt(changeValSegmented[0]);
          var changeMinutes = parseInt(changeValSegmented[1]);

          var changeByTime = new Date(0);                                     // stores the time increase requested
          console.log("Change By Time: " + changeByTime.getTime());

          changeByTime.setHours(changeByTime.getHours() + changeHours);
          changeByTime.setMinutes(changeByTime.getMinutes() + changeMinutes);
          
          console.log("Change By Time: " + changeByTime.getTime());
          
          //timeDiff = 600,000ms   changeByTime = 600,000ms   tickVal = 300,000
          //timeDiff = 600,000ms   changeByTime = 1,800,000ms tickVal = 150,000
          tickVal = (timeDiff * 1000) / (timeDiff + changeByTime.getTime());
          
          if(tickVal < MIN_TICK)
          {
            //clash = true;
            tickVal = MIN_TICK;
            failMessage = "Time Warp speed too high. Try increasing the Speed Up duration or reducing By duration.";
          }
        }
        else if(content.Settings[receivedID].timeWarp_change_select == "2")   // % selected
        {
          var percent = parseFloat(content.Settings[receivedID].timeWarp_change_input);
          if(!isNaN(tickVal))
          {
            // 0%   : 1000ms
            // 50%  : 750ms
            // 100% : 500ms
            // 400% : 200ms
            tickVal = 100000 / (100 + percent);
            
            if(tickVal < MIN_TICK)
            {
              //clash = true;
              tickVal = MIN_TICK;
              failMessage = "Time Warp speed too high. Try increasing the Speed Up duration or reducing By percentage.";
            }
          }
          else
          {
            clash = true;
            failMessage = "% value is not valid.";
          }
        }        
      }
      else if(content.Settings[receivedID].timeWarp_speed_select == "2")      // Slow down selected
      {
        if(content.Settings[receivedID].timeWarp_change_select == "1")        // hours selected
        {
          // what's the time difference between the start and end time in ms
          var timeDiff = activeTimes[0].endTime.getTime() - activeTimes[0].startTime.getTime();
          
          var changeValSegmented = content.Settings[receivedID].timeWarp_change_input.split(":");
          var changeHours = parseInt(changeValSegmented[0]);
          var changeMinutes = parseInt(changeValSegmented[1]);

          var changeByTime = new Date(0);                                     // stores the time increase requested
          changeByTime.setHours(changeByTime.getHours() + changeHours);
          changeByTime.setMinutes(changeByTime.getMinutes() + changeMinutes);
          
          //timeDiff = 600,000ms   changeByTime = 600,000ms   tickVal = 1,200,000
          //timeDiff = 600,000ms   changeByTime = 1,800,000ms tickVal = 150,000
          //var tickCount = timeDiff / 1000;                                    // number of seconds in timeDiff
          //tickVal = (changeByTime.getTime() + timeDiff) / tickCount;
          if(timeDiff - changeByTime.getTime() > 0)
            tickVal = (timeDiff * 1000) / (timeDiff - changeByTime.getTime());
          else// if(timeDiff - changeByTime.getTime() == 0)
            tickVal = null;                                                      // stop clock
          /*else
          {
            failMessage = "By duration cannot be greater than Slow Down duration.";
            clash = true;
          }*/
        }
        else if(content.Settings[receivedID].timeWarp_change_select == "2")   // % selected
        {
          var percent = parseFloat(content.Settings[receivedID].timeWarp_change_input);
          if(!isNaN(tickVal))
          {
            // 0%   : 1000ms
            // 50%  : 1500ms
            // 100% : 2000ms
            // 500% : 6000ms
            if(100 - percent > 0)
              tickVal = 100000 / (100 - percent);
            else //if(100 - percent == 0)
              tickVal = null;
            /*else
            {
              failMessage = "By % cannot be greater than 100% for Slow Down option.";
              clash = true;
            }*/
          }
          else
          {
            failMessage = "By % value is not valid.";
            clash = true;
          }
        }
      }
      else if(content.Settings[receivedID].timeWarp_speed_select == "3")      // Stop selected
      {
        tickVal = null;
      }
      else if(content.Settings[receivedID].timeWarp_speed_select == "4")      // Sync selected
      {
        tickVal = 0;
      }
      
      // add tickVal calculated to all the activeTimes schedules
      for(i = 0; i < activeTimes.length; i++)
      {
        activeTimes[i].tick = tickVal;
      }
      //console.log("Active Times: " + JSON.stringify(activeTimes));
      
      // check for clash!!! If this setting clashes with another active one, do not turn it ON
      for(i = 0; i < activeTimes.length && !clash; i++)                       // loop through all the schedules just calculated
      {
        //var activeTimesStartTime = new Date(activeTimes[i].startTime.getTime());
        //var activeTimesEndTime = new Date(activeTimes[i].endTime.getTime());
        
        //console.log("i: " + i + " " + JSON.stringify(activeTimes[i]));
        for(j = 0; j < content.Settings.length && !clash; j++)                // loop through all the settings  
        {
          //console.log("j: " + j);
          
          if(j == receivedID)                                                 // do not check against itself
            continue;
          
          if(content.Settings[j].active == "yo")                              // if setting is ON
          {
            for(k = 0; k < content.Settings[j].activeTimes.length && !clash; k++)    // loop through all the schedules in the setting
            {
              //console.log("k: " + k);

              var contentStartTime = new Date(content.Settings[j].activeTimes[k].startTime);
              var contentEndTime = new Date(content.Settings[j].activeTimes[k].endTime);
              
              //console.log(contentStartTime.toUTCString() + "   " + contentEndTime.toUTCString());
              
              if(activeTimes[i].startTime >= contentStartTime && activeTimes[i].startTime < contentEndTime)
                clash = true;
                
              if(activeTimes[i].endTime > contentStartTime && activeTimes[i].endTime <= contentEndTime)
                clash = true;
                
              if(clash)
              {
                console.log("Clash of " + JSON.stringify(activeTimes[i]) + " with " + JSON.stringify(content.Settings[j].activeTimes[k]));
                failMessage = "This setting's duration overlaps with: '" + content.Settings[j].title + "'.";
              }
            }
          }
        }
      }
            
      if(!clash)
      {
        content.Settings[receivedID].activeTimes = activeTimes;
        content.Settings[receivedID].active = req.body.active;
        
        console.log("Saved Active Times: " + JSON.stringify(content.Settings[receivedID].activeTimes));
      }
      else
        success = false;
    }
  }
  else
  {
    success = false;
    failMessage = "Setting not found in saved settings. Try reloading the page.";
  }
  
  if(success)
  {
    //Serialize as JSON and Write it to a file
    fs.writeFileSync(filename, JSON.stringify(content));
    
    checkScheduler();
    
    res.end("Success!");
  }
  else
    res.end(failMessage);
})

app.post('/sync', urlencodedParser, function (req, res)
{
  if(clockStarted)                                                                   // have we started the clock? After a fresh restart of edison, should only happen after a client logs in
  {
    res.end("Fail");
  }
  else
  {
    var currTime = new Date();
    //currTime.setTime(currTime.getTime() + sysTimeAdjustment);
    
    console.log("User's system time: " + req.body.sysTime);
    var clientSysTime = new Date(req.body.sysTime + 500);                           // 500ms network propagation delay
    //clientSysTime.setTime(clientSysTime.getTime());
    //console.log(clientSysTime.getHours());
    
    console.log("User's timezone: " + req.body.timezone);
    console.log("Server's timezone: " + new Date().getTimezoneOffset());
    
    timezoneOffset = new Date().getTimezoneOffset() - req.body.timezone;
    
    console.log("Server time:" + currTime);
    sysTimeAdjustment = clientSysTime.getTime() - currTime.getTime() + (timezoneOffset * 60000);
    console.log("Server Time Adjustement: " + sysTimeAdjustment);

    var serverStartTime = new Date(clientSysTime.getTime() + 0);                        // save the time. 
    serverStartTime.setTime(new Date().getTime() + sysTimeAdjustment); //serverStartTime.getTime() + sysTimeAdjustment);
    console.log("Updated Server Time: " + serverStartTime.toUTCString());
    
    clockFaceHour = serverStartTime.getHours();                                       // hour which should be displaying on the clock face
    clockFaceMinute = serverStartTime.getMinutes();                                   // minute which should be displaying on the clock face
    clockFaceSecond = serverStartTime.getSeconds();                                   // second which should be displaying on the clock face
    if(clockFaceHour > 11)                                                            // if hour is in 24 hour format
      clockFaceHour -= 12;                                                            // change to 12 hour format
    clockStarted = true;                                                              // start the clock
    
    setTickDuration(1000);                                                            // start ticking at 1 second tick
    
    var schedulerIntervalObj = setInterval(checkScheduler, 3600000);                  // after every one hour interval, keep checking if new schedules have some in 48hour scope
  //    checkScheduler();                                                                 // populate scheduler
    
    checkScheduler();                                                                   // some schedules may have expired and some may have come in scope due to time change
    
    res.end("Success!");
  }
})

var server = http.listen(8008, function ()
{
  var host = server.address().address
  var port = server.address().port

  console.log("Example app listening at http://%s:%s", host, port)

})

// scheduler: contains all the time durations which are active for next 48 hours. {startTime, endTime, repeat, id, tick};
var scheduler = [];

// contains the current running schedule
var runningDuration = null;

// Object for stopping the timeOut prematurely if required
var timeoutObj = null;


function loadScheduler()                                                  // clear the scheduler of expired schedules and load new ones from JSON
{
  var currTime = new Date();                                              // time right now
  currTime.setTime(currTime.getTime() + sysTimeAdjustment);
  var time48HrLater = new Date(currTime.getTime() + 172800000);           // number of milliseconds in 48 hours added to currDate's milliseconds

  // read the local JSON file into javascript JSON object 'content'
  var filename = __dirname + "/public/settings.json";
  var file_content = fs.readFileSync(filename);
  var content = JSON.parse(file_content);
  
  var isContentModified = false;                                          // were any changes made to content which will need to be saved at the end?
  
  // empty the activeSettings array
  //while(activeSettings.length > 0)
  //  activeSettings.pop();
  
  // remove all expired schedules from scheduler
  for(i = 0; i < scheduler.length; i++)                                   // loop through all the active durations in scheduler
  {
    if(scheduler[i].endTime < currTime)                                   // the time duration has expired
    {
      scheduler.splice(i, 1);
      
      if(runningDuration > i)                                             // if runningDuration is after entry i
        runningDuration--;                                                // reduce runningDuration by one as entry i was removed and all elements have shifted one pos up
      
      i--;                                                                // compensate for removed element in loop, else element newly shifted to i will be skipped.

      // set it to OFF in JSON file
      // if(scheduler[i].id < content.Settings.length)
      // {
        // if(scheduler[i].repeat == "no")
          // content.Settings[scheduler[i].id].active = "no";
          
        // isContentModified = true;
      // }
    }
  }
  
  
  for(i = 0; i < content.Settings.length; i++)                            // loop through all the saved settings
  {
    if(!content.Settings[i].hasOwnProperty("active"))                     // if the setting doesn't have a key named 'active'
      continue;
      
    if(content.Settings[i].active == "no")                                // if the setting is OFF
    {
      // remove any schedule whose setting is set to OFF in JSON file
      for(j = 0; j < scheduler.length; j++)                               // loop through all schedules
      {
        if(scheduler[j].id == i)                                          // a schedule is from this disabled setting
        {
          scheduler.splice(j, 1);                                         // remove the scheduler entry
        
          if(runningDuration != null)
          {
            if(runningDuration == j)                                      // the setting having the running schedule was turned OFF
            {
              clearTimeout(timeoutObj);                                   // remove the timeout
              runningDuration = null;
              
              // stop using the setting!!!
              setTickDuration(1000);
            }
            else if(runningDuration > j)                                  // if running schedule has index which appears after the deleted entry
              runningDuration--;                                          // reduce runningDuration by one to compensate for deleted entry
          }
          
          j--;
        }
      }
      //continue;
    }
    else                                                                    // if the setting is ON
    {
      //var activeTimes = content.Settings[i].activeTimes;                  // get the array of durations for which setting is active
      for(j = 0; j < content.Settings[i].activeTimes.length; j++)           // loop through all the active time durations
      {
        var startTime = new Date(content.Settings[i].activeTimes[j].startTime);                 // convert JSON startTime to javascript Date object for current duration
        var endTime = new Date(content.Settings[i].activeTimes[j].endTime);                     // convert JSON endTime to javascript Date object for current duration
        var isRepeated = (content.Settings[i].activeTimes[j].repeat == "yo") ? true : false;    // is the repeated set to true?
        
        var tickVal = null;
        
        if(content.Settings[i].activeTimes[j].tick != null)
        {
          tickVal = parseInt(content.Settings[i].activeTimes[j].tick);                        // convert the tick to integer value in ms
        }
        
        // get the entry for this schedule as accepted by scheduler
        var schedulerEntry = {startTime: startTime, endTime: endTime, repeat: isRepeated, id: i, tick: tickVal};
        
        if(startTime > currTime)                                            // if the current duration hasn't started yet
        {
          if(startTime < time48HrLater)                                     // if the current duration will start within 48 hours
          {
            // add to scheduler
            if(searchScheduler(schedulerEntry) == -1)                       // if entry doesn't exist in scheduler
              scheduler.push(schedulerEntry);                               // add new entry at the end
          }
        }
        else                                                                // if the current duration has already started
        {
          if(endTime > currTime)                                            // if the current duration has yet to end
          {
            if(runningDuration == null)                                     // if no scheduler entry is running
            {
              // add to scheduler
              if(searchScheduler(schedulerEntry) == -1)
                scheduler.push(schedulerEntry);
            }
            else if(scheduler[runningDuration].id != i)                     // running scheduler entry isn't this one
            {
              // clash of 2 settings running together. Do nothing. Let the one running finish
              console.log("Running schedule is clashing with another " + JSON.stringify(scheduler[runningDuration]) + " " + JSON.stringify(content.Settings[i]));
            }
          }
          else                                                              // if the current duration has already ended i.e. setting is expired
          {
            var searchResult = searchScheduler(schedulerEntry);
            if(searchResult != -1)                                          // if the schedule exists in scheduler
            {
              scheduler.splice(searchResult, 1);                            // remove the scheduler entry
              
              if(runningDuration != null)
              {
                // if(runningDuration == searchResult)
                // {
                  // timeoutObj.clearTimeout();                                            // remove the timeout
                  // runningDuration = null;
                // }
                // else 
                if(runningDuration > searchResult) // if running schedule has index which appears after the deleted entry
                  runningDuration--;                                          // reduce runningDuration by one to compensate for deleted entry
              }
            }

            if(content.Settings[i].activeTimes[j].repeat == "yo")                               // if the setting is repeatable
            {
              // set it for next week
              var newStartTime = new Date(startTime.getTime());
              var newEndTime = new Date(endTime.getTime());

              // due to change in system time, we may have gone forward days, weeks, months or years. Keep adding 1 week till we catch up
              while(endTime < currTime)                                                       // keep adding weeks until schedule's end time is later than now
              {
                newStartTime.setDate(newStartTime.getDate() + 7);
                newEndTime.setDate(newEndTime.getDate() + 7);
              }
              
              content.Settings[i].activeTimes[j].startTime = newStartTime.toJSON();
              content.Settings[i].activeTimes[j].endTime = newEndTime.toJSON();
              isContentModified = true;
            }
            else                                                            // if the setting was one-time thing
            {
              if(content.Settings[i].activeTimes.length == 1)                                   // there should only be one time duration in the setting for no repeat
              {
                // turn setting OFF
                // var searchResult = searchScheduler(schedulerEntry);         // search for this entry in scheduler
                // if(searchResult != -1)                                      // if found
                // {
                  // if(runningDuration != null)                               // if runningDuration isn't null
                  // {
                    // if(runningDuration == searchResult)                     // if this was the active result and somehow we ended up here before is could be deactivated by timeout
                      // runningDuration = null;                               // no running duration
                    // else if(runningDuration > searchResult)                 // searchResult points to a scheduler entry AFTER the value we're going to delete
                      // runningDuration--;                                    // reduce by 1 to compensate for the deleted entry
                  // }
                  
                  // scheduler.splice(searchResult, 1);                        // delete this entry as it is expired
                // }
                
                content.Settings[i].active = "no";                          // set this setting as inactive in JSON file
                isContentModified = true;
              }
              else                                                          // other time durations exist in the setting
              {
                // This is a corrupted value. Delete this entry.
                console.log("Corrupted entry. Deleting: " + JSON.stringify(content.Settings[i].activeTimes[j]) + " from " + i);
                content.Settings[i].activeTimes.splice(j, 1);
                isContentModified = true;
              }
            }
          }
        }
      }
    }
  }
  
  if(isContentModified)                                                   // if the content object was modified
  {
    fs.writeFileSync(filename, JSON.stringify(content));                  // write the changes to JSON file
    io.emit('reload active');
  }
  console.log("Scheduler: " + JSON.stringify(scheduler));
  
  //force page at client to loadJSON file!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}

function searchScheduler(entry)
{
  for(k = 0; k < scheduler.length; k++)                                   // loop through scheduler
  {
    // check if entry matches existing entry in scheduler
    if(scheduler[k].id == entry.id && scheduler[k].startTime.getTime() == entry.startTime.getTime() && scheduler[k].endTime.getTime() == entry.endTime.getTime())
      return k;
  }
  
  return -1;
}

function checkScheduler()
{
  var currTime = new Date();                                              // time right now
  currTime.setTime(currTime.getTime() + sysTimeAdjustment);
  var minStartTimeIndex = 0;                                              // minimum startTime's index from all scheduler entries. initialize as the first entry

  // make sure runningDuration hasn't expired
  if(runningDuration != null)
  {
    if(scheduler[runningDuration].endTime <= currTime)                    // if the running schedule's endTime has already passed, i.e. expired
    {
      scheduler.splice(runningDuration, 1);                               // delete this scheduler entry
      
      clearTimeout(timeoutObj);                                           // remove the timeout
      runningDuration = null;
    }
  }

  loadScheduler();                                                        // load new values to scheduler. Set expired settings to OFF in JSON file and remove from scheduler
  
  if(scheduler.length == 0)                                               // scheduler is empty
    return;
  
  if(runningDuration != null)                                             // if there is no need to calculate new runningDuration, exit
    return;
  
  for(i = 0; i < scheduler.length; i++)
  {
    // safeguard against some expired value becoming the minStartTimeIndex. Isn't necessary but may be needed for corrupted data or changed system clock
    // if(scheduler[i].endTime < currTime)                                   // if the schedule's endTime has already passed, i.e. expired
    // {
      // scheduler.splice(i, 1);                                             // delete this scheduler entry
      
      if(i == runningDuration)                                            // if this is the running time duration. Somehow timeOut hasn't triggered yet
      // {
        timeoutObj.clearTimeout();                                        // remove the timeout
        runningDuration = null;        
      // }
      
      // i--;                                                                // next entry in scheduler has taken this one's place. Repeat check for this same index again.
      // continue;
    // }
    
    if(scheduler[i].startTime < scheduler[minStartTimeIndex].startTime)   // if the current startTime is less than the minimum
      minStartTimeIndex = i;                                              // set minimum to current    
  }
  
//  if(scheduler.length == 0)                                               // stop if we removed all elements
//    return;
  
  if(scheduler[minStartTimeIndex].startTime > currTime)                   // the time duration will begin after some time
  {
    if(timeoutObj != null)
      clearTimeout(timeoutObj);
    // set a timeout for auto-start the time duration
    timeoutObj = setTimeout(startRunningDuration, scheduler[minStartTimeIndex].startTime.getTime() - currTime.getTime(), minStartTimeIndex);
  }
  else                                                                    // should the setting already be in running state?
  {
    startRunningDuration(minStartTimeIndex);
    //setTimeout(stopRunningDuration, scheduler[runningDuration].endTime.getTime() - scheduler[runningDuration].startTime.getTime());
  }

}

function startRunningDuration(id)
{
  runningDuration = id;                                                   // assign new id to runningDuration
  
  var currTime = new Date();
  currTime.setTime(currTime.getTime() + sysTimeAdjustment);
  var scheduleDuration = scheduler[runningDuration].endTime.getTime() - currTime.getTime();   // how long will this schedule last?
  
  if(timeoutObj != null)                                                  // if timeout is assigned
    clearTimeout(timeoutObj);                                             // clear it
  timeoutObj = setTimeout(stopRunningDuration, scheduleDuration);         // set timeout for when schedule will end
  
  console.log("Waiting for " + scheduleDuration.toString() + " ms");
  
  if(scheduler[runningDuration].tick == "null")
  {
    console.log("WE GOT NULL!!!");
  }
  if(scheduler[runningDuration].tick == 0)                                // we have to sync the clock
  {
    var nearestMatch = new Date(currTime.getTime());                         // time on clock face taken as occurring in previous 12 hours
    nearestMatch.setHours(clockFaceHour);
    nearestMatch.setMinutes(clockFaceMinute);
    nearestMatch.setSeconds(clockFaceSecond);

    var msIn6Hrs = 6 * 60 * 60 * 1000;
    var nearestMatchTimeDiff = currTime.getTime() - nearestMatch.getTime();
    while(Math.abs(nearestMatchTimeDiff) > msIn6Hrs)
    {
      if(currTime > nearestMatch)
        nearestMatch.setHours(nearestMatch.getHours() + 12);
      else
        nearestMatch.setHours(nearestMatch.getHours() - 12);
        
      nearestMatchTimeDiff = currTime.getTime() - nearestMatch.getTime();
    }
    
    console.log("Nearest Match: " + nearestMatch.toString());
    console.log("nearestMatchTimeDiff: " + nearestMatchTimeDiff.toString());
/*    var nextMatch = new Date(prevMatch.getTime());                        // time on clock face taken as occurring in next 12 hours
    
    if(prevMatch < currTime)                                              // if prev time was correct
      nextMatch.setHours(nextMatch.getHours() + 12);                      // get next time which is 12 hours later
    else                                                                  // prev time was incorrect
      prevMatch.setHours(prevMatch.getHours() - 12);                      // remove 12 hours to correct it
    
    console.log("scheduleDuration: " + scheduleDuration.toString());
    console.log("prevMatch: " + prevMatch.toString());
    console.log("nextMatch: " + nextMatch.toString());*/
    
//    var prevMatchTimeDiff = Math.abs(currTime.getTime() - prevMatch.getTime());    // time diff between now and prevMatch
//    var nextMatchTimeDiff = Math.abs(nextMatch.getTime() - currTime.getTime());    // time diff between now and prevMatch
    var tickVal = 0;                                                      // calculated tick
    
//    console.log("prevMatchTimeDiff: " + prevMatchTimeDiff.toString());
//    console.log("nextMatchTimeDiff: " + nextMatchTimeDiff.toString());
    
    //if(prevMatchTimeDiff < nextMatchTimeDiff)                             // Time on clock face is behind. Speed up to help it meet currTime
    if(nearestMatchTimeDiff > 0)    // i.e. currTime > nearestMatch
    {
      tickVal = (scheduleDuration * 1000) / (scheduleDuration + nearestMatchTimeDiff);
      
      if(tickVal < MIN_TICK)                                              // going too fast?
        tickVal = MIN_TICK;                                               // throttle speed to max speed(or min tick time)  
    }
    else if(nearestMatchTimeDiff < 0)                                     // Time on clock face is behind. Slow down to help it meet currTime
    {
      if(Math.abs(nearestMatchTimeDiff) < scheduleDuration)                            // time to recover is less than time we have been allotted to sync
        tickVal = (scheduleDuration * 1000) / (scheduleDuration + nearestMatchTimeDiff);
      else                                                                // time to recover is more than time available for syncing
        tickVal = null;                                                   // Go the slowest, i.e. stop the clock
    }
    console.log("TickVal: " + tickVal);
    if(tickVal == null)
      scheduler[runningDuration].tick = null;
    else
      scheduler[runningDuration].tick = Math.round(tickVal);
  }
  
  // start using the setting!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  setTickDuration(scheduler[runningDuration].tick);
  console.log("Starting " + id);
}

function stopRunningDuration()
{
  // stop using the setting!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  setTickDuration(1000);
  console.log("Stopping " + runningDuration);

  scheduler.splice(runningDuration, 1);                                   // delete the entry from scheduler
  
  // set active in JSON file to "no"??? .If repeated, set it to next week???
  // handled by checkScheduler
  
  runningDuration = null;
  
  checkScheduler();
}

var MIN_TICK = 100;                                                       // minimum tick duration value allowed. Lower than this and the clock may start skipping ticks
var tickDuration = null;                                                  // how long between each second hand tick
var pulseReversed = true;                                                 // pulses to clock solenoid needs to be reversed on each tick. This keeps tab of which pulse to send
var tickIntervalObj = null;                                               // keeps link to setInterval for ticking
var sysTimeAdjustment = 0;                                                // how many ms do we need to adjust edison system time to match actual time

//var serverStartTime = new Date();
var clockFaceHour = 0;                                                    // hour which should be displaying on the clock face (except when set to 12)
var clockFaceMinute = 0;                                                  // minute which should be displaying on the clock face (except when set to 12)
var clockFaceSecond = 0;                                                 // second which should be displaying on the clock face (except when set to 12)
var clockStarted = false;                                                 // have we started the clock. Should only happen after a client logs in after a fresh restart
var timezoneOffset = 0;

function TickTickTick()                                                   // updates Clock Face Time stored by one second
{
  // add a second to clock face time
  clockFaceSecond++;
  if(clockFaceSecond >= 60)
  {
    clockFaceSecond -= 60;
    
    clockFaceMinute++;
    if(clockFaceMinute >= 60)
    {
      clockFaceMinute -= 60;
      
      clockFaceHour++;
      if(clockFaceHour >= 12)
        clockFaceHour -= 12;
    }
  }
  
  sendSysTime();
  TickTock();
}

function TickTock()                                                         // moves second hand one tick  
{
    // send one tick pulse
  //  analogWrite(enablePin, 170);
  //  digitalWrite(clockPin1, !pulseReversed);
  //  digitalWrite(clockPin2, pulseReversed);

    clockPin1.write(pulseReversed ? 0 : 1);                                 // send pulse for pin1
    clockPin2.write(pulseReversed ? 1 : 0);                                 // send pulse for pin2. should be opposite of pin1's pulse
    
    //console.log((!pulseReversed ? "tick!" : "tock!") + " " + clockFaceHour + ":" + clockFaceMinute + ":" + clockFaceSecond);
    pulseReversed = !pulseReversed;                                         // pulses need to be swapped for pin1 and pin2 next time
}

function setTickDuration(duration)                                        // set the time between 2 second hand ticks
{
  if(tickIntervalObj != null)                                             // if the clock isn't stopped
    clearInterval(tickIntervalObj);                                       // stop the setInterval
  
  tickDuration = duration;                                                // save duration in milliseconds  
  if(duration != null)                                                    // clock isn't supposed to be stopped
    tickIntervalObj = setInterval(TickTickTick, tickDuration);            // set the clock ticking
    
  console.log("Setting clock tick to: " + tickDuration);
}

function sendSysTime()
{
  io.emit('clock update', {hour: clockFaceHour, minute: clockFaceMinute, second: clockFaceSecond, sysTime: (new Date().getTime() + sysTimeAdjustment - (timezoneOffset * 60000))});
}


var sysTimeInterval = setInterval(sendSysTime, 1000);                     // send the system time to client